<?php
// Cargar WordPress
require_once(__DIR__ . '/../../../wordpress/wp-load.php');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Oficina de Gestion de la Calidad de la Universidad Nacional de San Martin - UNSM">
    <meta name="keywords" content="UNSM, Gestion de la Calidad, Universidad San Martin, Acreditacion, Calidad Educativa">
    <meta name="author" content="Universidad Nacional de San Martin">
    <meta name="robots" content="index, follow">
    <meta name="theme-color" content="#359444">

    <title>Gestion de la Calidad - UNSM</title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="../../../imagenes/escudo unsm.png" sizes="48x48">

    <!-- Stylesheet Principal -->
    <link rel="stylesheet" href="../../../css/style.css">
    <!-- Stylesheet Gestion de la Calidad -->
    <link rel="stylesheet" href="style/styleGesCali.css?v=1.0">
</head>
<body>
    <!-- Header Superior -->
    <header class="top-header" role="banner">
        <div class="top-header-content">
            <nav class="social-icons" aria-label="Redes sociales">
                <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Siguenos en Facebook" aria-label="Pagina oficial de Facebook de la UNSM">
                    <img src="../../../imagenes/redes/logo facebook.png" alt="Facebook" width="36" height="36">
                </a>
                <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" title="Siguenos en Instagram" aria-label="Perfil oficial de Instagram de la UNSM">
                    <img src="../../../imagenes/redes/logo instagram.png" alt="Instagram" width="36" height="36">
                </a>
                <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" title="Visita nuestro canal de YouTube" aria-label="Canal oficial de YouTube de la UNSM">
                    <img src="../../../imagenes/redes/logo yt.png" alt="YouTube" width="36" height="36">
                </a>
                <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Siguenos en X (Twitter)" aria-label="Cuenta oficial de X de la UNSM">
                    <img src="../../../imagenes/redes/logo x.png" alt="X (Twitter)" width="36" height="36">
                </a>
                <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" title="Siguenos en TikTok" aria-label="Perfil oficial de TikTok de la UNSM">
                    <img src="../../../imagenes/redes/logo tiktok.png" alt="TikTok" width="36" height="36">
                </a>
            </nav>
            <div class="contact-info">
                <span>
                    <img src="../../../imagenes/logo telefono.png" alt="Telefono" class="contact-icon" width="18" height="18">
                    <span>(+51) (042) 48 0159</span>
                </span>
                <span>
                    <img src="../../../imagenes/logo correo.png" alt="Correo" class="contact-icon" width="18" height="18">
                    <span>informes@unsm.edu.pe</span>
                </span>
            </div>
        </div>
    </header>

    <!-- Header Principal -->
    <header class="main-header">
        <div class="main-header-content">
            <div class="logo">
                <a href="../../../" aria-label="Ir a la pagina principal de UNSM">
                    <img src="../../../imagenes/logo UNSM.png" alt="Logo de la Universidad Nacional de San Martin" width="auto" height="70">
                </a>
            </div>

            <!-- Boton Hamburguesa para movil -->
            <button class="mobile-menu-toggle" aria-label="Abrir menu de navegacion" aria-expanded="false" aria-controls="main-navigation">
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
            </button>

            <nav class="main-nav" id="main-navigation" aria-label="Navegacion principal">
                <div class="mobile-nav-logo">
                    <img src="../../../imagenes/logo UNSM.png" alt="Logo UNSM" width="auto" height="65">
                </div>

                <ul class="nav-menu">
                    <li class="dropdown">
                        <a href="../../../#nosotros" aria-haspopup="true" aria-expanded="false">NOSOTROS</a>
                        <ul class="dropdown-menu" aria-label="Menu Nosotros">
                            <li><a href="../../../nosotros/autoridades/indexAuto.php">Autoridades</a></li>
                            <li><a href="../../../nosotros/historia/historia.php">Historia de la Universidad</a></li>
                            <li><a href="../../../nosotros/mision/indexMision.php">Nuestra Mision y Vision</a></li>
                            <li><a href="../../../nosotros/objetivos/objeIndex.php">Objetivos</a></li>
                            <li><a href="../../../nosotros/onigrama/indexOni.php">Organigrama</a></li>
                            <li><a href="../../../nosotros/himno/indexHimno.php">Himno</a></li>
                            <li><a href="../../../nosotros/directorioInstucional/indexDirec.php">Directorio Institucional</a></li>
                            <li><a href="../../../nosotros/calendarioAcade/indexCale.php">Calendario Academico</a></li>
                        </ul>
                    </li>
                    <li class="dropdown dropdown-wide">
                        <a href="../../../#oficinas" aria-haspopup="true" aria-expanded="false">OFICINAS</a>
                        <ul class="dropdown-menu dropdown-columns" aria-label="Menu Oficinas">
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Administrativas</li>
                                <li><a href="../../../oficinas/rectorado/indexRecto.php">Rectorado</a></li>
                                <li><a href="../../../oficinas/vicerrectorado academico/indexVicerec.php">Vicerrectorado Academico</a></li>
                                <li><a href="../../../oficinas/vicerrectorado de investigacion/indexViceRecAca.php">Vicerrectorado de Investigacion</a></li>
                                <li><a href="../../../oficinas/secretaria general/indexSecreGene.php">Secretaria General</a></li>
                                <li><a href="../../../oficinas/planeamiento y presupuesto/indexPlanea.php">Planeamiento y Presupuesto</a></li>
                                <li><a href="../../../oficinas/seguridad y salud ocupacional/indexSeguri.php">Seguridad y Salud Ocupacional</a></li>
                                <li><a href="../../../oficinas/comunicacion y imagen institucional/indexImagen.php">Comunicacion e Imagen Institucional</a></li>
                                <li><a href="../../../oficinas/Cooperacion y Relaciones Internacionales/indexCoopera.php">Cooperacion y Relaciones Internacionales</a></li>
                                <li><a href="../../../oficinas/Organo de Control Institucional/indexOrgaConIns.php">Organo de Control Institucional</a></li>
                                <li><a href="../../../oficinas/Ejecutora de Inversiones/indexEjec.php">Ejecutora de Inversiones</a></li>
                                <li><a href="../../../oficinas/Asesoria Juridica/indexAseJuri.php">Asesoria Juridica</a></li>
                                <li><a href="../../../oficinas/Grados y Titulos/indexGrados.php">Grados y Titulos</a></li>
                            </div>
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Academicas</li>
                                <li><a href="../OFICINA DE ADMISION/indexOfiAdmin.php">Oficina de Admision</a></li>
                                <li><a href="../ASUNTOS ACADEMICOS/indexAsunAca.php">Asuntos Academicos</a></li>
                                <li><a href="../Seguimiento al Egresado e Insercion Laboral/indexSegui.php">Seguimiento al Egresado e Insercion Laboral</a></li>
                                <li><a href="../TECNOLOGIAS DE LA INFORMACION/indexOTI.php">Tecnologias de la Informacion</a></li>
                                <li><a href="../INCUBADORA DE EMPRESAS/indexIncu.php">Incubadora de Empresas</a></li>
                                <li><a href="../FONDO EDITORIAL/indexFondo.php">Fondo Editorial</a></li>
                                <li><a href="../COMITE ELECTORAL UNIVERSITARIO/indexComite.php">Comite Electoral Universitario</a></li>
                                <li><a href="../INNOVACION Y TRANSFERENCIA TECNOLOGICA/indexInno.php">Innovacion y Transferencia Tecnologica</a></li>
                                <li><a href="../PRODUCCION DE BIENES Y SERVICIOS/indexProdu.php">Produccion de Bienes y Servicios</a></li>
                                <li><a href="../RESPONSABILIDAD SOCIAL UNIVERSITARIA/indexRespon.php">Responsabilidad Social Universitaria</a></li>
                                <li><a href="../SERVICIOS GENERALES/indexServiGe.php">Servicios Generales</a></li>
                                <li><a href="../BIENESTAR UNIVERSITARIO/indexBienUni.php">Bienestar Universitario</a></li>
                                <li><a href="../DEFENSORIA UNIVERSITARIA/indexDefUni.php">Defensoria Universitaria</a></li>
                                <li><a href="indexGesCali.php">Gestion de la Calidad</a></li>
                            </div>
                        </ul>
                    </li>
                    <li><a href="../../../oficinas/Academicos/OFICINA DE ADMISION/indexOfiAdmin.php">ADMISION</a></li>
                    <li><a href="../../../#cpu">CPU</a></li>
                    <li class="dropdown dropdown-facultades">
                        <a href="../../../#facultades" aria-haspopup="true" aria-expanded="false">FACULTADES</a>
                        <ul class="dropdown-menu" aria-label="Menu Facultades">
                            <li class="has-submenu">
                                <a href="../../../#ciencias-agrarias" aria-haspopup="true" aria-expanded="false">Ciencias Agrarias</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Agrarias">
                                    <li><a href="../../../#agronomia">Agronomia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ciencias-salud" aria-haspopup="true" aria-expanded="false">Ciencias de la Salud</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias de la Salud">
                                    <li><a href="../../../#obstetricia">Obstetricia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#medicina-veterinaria" aria-haspopup="true" aria-expanded="false">Medicina Veterinaria</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Veterinaria">
                                    <li><a href="../../../#medicina-veterinaria-carrera">Medicina Veterinaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ingenieria-agroindustrial" aria-haspopup="true" aria-expanded="false">Ingenieria Agroindustrial</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenieria Agroindustrial">
                                    <li><a href="../../../#ing-agroindustrial">Ingenieria Agroindustrial</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ingenieria-civil" aria-haspopup="true" aria-expanded="false">Ingenieria Civil y Arquitectura</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenieria Civil y Arquitectura">
                                    <li><a href="../../../#arquitectura">Arquitectura</a></li>
                                    <li><a href="../../../#ingenieria-civil-carrera">Ingenieria Civil</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ingenieria-sistemas" aria-haspopup="true" aria-expanded="false">Ingenieria de Sistemas e Informatica</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenieria de Sistemas">
                                    <li><a href="../../../#ing-sistemas">Ingenieria de Sistemas e Informatica</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ecologia" aria-haspopup="true" aria-expanded="false">Ecologia</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ecologia">
                                    <li><a href="../../../#ing-ambiental">Ingenieria Ambiental</a></li>
                                    <li><a href="../../../#ing-sanitaria">Ingenieria Sanitaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#derecho" aria-haspopup="true" aria-expanded="false">Derecho y Ciencias Politicas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Derecho">
                                    <li><a href="../../../#derecho-carrera">Derecho</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#medicina-humana" aria-haspopup="true" aria-expanded="false">Medicina Humana</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Humana">
                                    <li><a href="../../../#medicina-humana-carrera">Medicina Humana</a></li>
                                    <li><a href="../../../#enfermeria">Enfermeria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ciencias-economicas" aria-haspopup="true" aria-expanded="false">Ciencias Economicas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Economicas">
                                    <li><a href="../../../#administracion">Administracion</a></li>
                                    <li><a href="../../../#contabilidad">Contabilidad</a></li>
                                    <li><a href="../../../#economia">Economia</a></li>
                                    <li><a href="../../../#turismo">Turismo</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#educacion" aria-haspopup="true" aria-expanded="false">Educacion y Humanidades</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Educacion">
                                    <li><a href="../../../#educacion-inicial">Educacion Inicial</a></li>
                                    <li><a href="../../../#educacion-primaria">Educacion Primaria</a></li>
                                    <li><a href="../../../#educacion-secundaria">Educacion Secundaria</a></li>
                                    <li><a href="../../../#idiomas">Idiomas</a></li>
                                    <li>
                                        <a href="../../../#psicologia">
                                            Psicologia
                                            <span class="badge-nuevo">Nuevo</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="../../../#posgrado">POSGRADO</a></li>
                    <li class="dropdown">
                        <a href="../../../#transparencia" aria-haspopup="true" aria-expanded="false">TRANSPARENCIA</a>
                        <ul class="dropdown-menu" aria-label="Menu Transparencia">
                            <li><a href="#licenciamiento">Licenciamiento</a></li>
                            <li><a href="#institucional">Institucional Ley 30220</a></li>
                            <li><a href="#estandar">Estandar Ley 27806</a></li>
                        </ul>
                    </li>
                </ul>

                <div class="mobile-nav-gob-logos">
                    <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia de la UNSM">
                        <img src="../../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" width="auto" height="35">
                    </a>
                    <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Portal del Gobierno del Peru">
                        <img src="../../../imagenes/logo gobPe.png" alt="Gobierno del Peru" width="auto" height="35">
                    </a>
                </div>
            </nav>

            <div class="gob-logos">
                <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia">
                    <img src="../../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" class="portal-trans-logo" width="auto" height="32">
                </a>
                <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Gobierno del Peru">
                    <img src="../../../imagenes/logo gobPe.png" alt="Gobierno del Peru" class="gob-logo" width="auto" height="30">
                </a>
            </div>
        </div>
    </header>

    <!-- Banner Gestion de la Calidad -->
    <section class="calidad-banner">
        <div class="banner-container">
            <h1>GESTION DE LA CALIDAD</h1>
            <div class="banner-contact">
                <p><strong>Local Central, Jr. Maynas N° 177, Tarapoto, Peru</strong></p>
                <p>ogc@unsm.edu.pe</p>
            </div>
        </div>
    </section>

    <!-- Contenido Principal -->
    <main class="calidad-main">
        <div class="calidad-container">
            <!-- Sidebar con tabs -->
            <aside class="calidad-sidebar">
                <nav class="tabs-menu">
                    <button class="tab-button active" data-tab="inicio">
                        <span class="tab-icon">&#127968;</span>
                        <span class="tab-text">INICIO</span>
                    </button>
                    <button class="tab-button" data-tab="quienes-somos">
                        <span class="tab-icon">&#128101;</span>
                        <span class="tab-text">¿QUIENES SOMOS?</span>
                    </button>
                    <button class="tab-button" data-tab="normatividad">
                        <span class="tab-icon">&#128220;</span>
                        <span class="tab-text">NORMATIVIDAD</span>
                    </button>
                    <button class="tab-button" data-tab="logros">
                        <span class="tab-icon">&#127942;</span>
                        <span class="tab-text">LOGROS</span>
                    </button>
                    <button class="tab-button" data-tab="nosotros">
                        <span class="tab-icon">&#128100;</span>
                        <span class="tab-text">NOSOTROS</span>
                    </button>
                    <button class="tab-button" data-tab="contacto">
                        <span class="tab-icon">&#128222;</span>
                        <span class="tab-text">CONTACTO</span>
                    </button>
                    <button class="tab-button" data-tab="ubicacion">
                        <span class="tab-icon">&#128205;</span>
                        <span class="tab-text">UBICACION</span>
                    </button>
                    <button class="tab-button" data-tab="personal">
                        <span class="tab-icon">&#128106;</span>
                        <span class="tab-text">PERSONAL</span>
                    </button>
                    <button class="tab-button" data-tab="eventos">
                        <span class="tab-icon">&#128197;</span>
                        <span class="tab-text">EVENTOS</span>
                    </button>
                </nav>
            </aside>

            <!-- Contenido principal -->
            <div class="calidad-content">
                <!-- Tab de Inicio -->
                <div class="tab-content active" id="inicio">
                    <div class="content-wrapper">
                        <h2>BIENVENIDOS</h2>
                        <p>La Oficina de Gestion de la Calidad de la Universidad Nacional de San Martin (UNSM) es la unidad organica encargada de promover, coordinar y supervisar los procesos de aseguramiento de la calidad educativa en la institucion.</p>

                        <p>Nuestra oficina trabaja de manera articulada con todas las facultades, escuelas profesionales y unidades academicas para garantizar el cumplimiento de los estandares de calidad establecidos por SUNEDU y SINEACE, contribuyendo asi a la mejora continua de los procesos academicos y administrativos.</p>

                        <p>Estamos comprometidos con la excelencia academica y la formacion integral de profesionales competentes que contribuyan al desarrollo sostenible de la region San Martin y del pais.</p>
                    </div>

                    <!-- Widget de Noticias/Latest Posts -->
                    <aside class="noticias-widget">
                        <h3>Latest Posts</h3>
                        <div class="noticias-container">
                            <?php
                            // Obtener ultimos posts desde WordPress
                            $latest_posts_args = array(
                                'post_type'      => 'post',
                                'posts_per_page' => 5,
                                'orderby'        => 'date',
                                'order'          => 'DESC',
                                'post_status'    => 'publish'
                            );

                            $latest_posts_query = new WP_Query($latest_posts_args);

                            if ($latest_posts_query->have_posts()) :
                                while ($latest_posts_query->have_posts()) : $latest_posts_query->the_post();
                            ?>
                                <div class="noticia-item">
                                    <a href="<?php the_permalink(); ?>" class="noticia-link">
                                        <span class="noticia-fecha"><?php echo get_the_date('d M Y'); ?></span>
                                        <p class="noticia-titulo"><?php the_title(); ?></p>
                                    </a>
                                </div>
                            <?php
                                endwhile;
                                wp_reset_postdata();
                            else :
                            ?>
                                <p class="no-posts">No hay publicaciones recientes.</p>
                            <?php endif; ?>
                            <div class="calendario-actions">
                                <a href="<?php echo home_url('/blog'); ?>" class="btn-calendar">Ver Mas Noticias &#9656;</a>
                            </div>
                        </div>
                    </aside>
                </div>

                <!-- Tab de Quienes Somos -->
                <div class="tab-content" id="quienes-somos">
                    <div class="content-wrapper">
                        <h2>¿QUIENES SOMOS?</h2>
                        <p>La Oficina de Gestion de la Calidad (OGC) es un organo de apoyo academico que depende del Vicerrectorado Academico de la Universidad Nacional de San Martin.</p>

                        <h3>Mision</h3>
                        <p>Promover y asegurar la calidad de los procesos academicos y administrativos de la UNSM, mediante la implementacion de sistemas de gestion de calidad, evaluacion y mejora continua, contribuyendo al logro de los objetivos institucionales y la satisfaccion de la comunidad universitaria.</p>

                        <h3>Vision</h3>
                        <p>Ser una oficina lider en la gestion de la calidad educativa universitaria en la region amazonica, reconocida por su eficiencia, innovacion y compromiso con la excelencia academica.</p>

                        <h3>Valores</h3>
                        <ul class="funciones-list">
                            <li><strong>Excelencia:</strong> Busqueda permanente de la mejora continua en todos los procesos.</li>
                            <li><strong>Compromiso:</strong> Dedicacion plena al logro de los objetivos institucionales.</li>
                            <li><strong>Transparencia:</strong> Actuacion clara y verificable en todos los procesos.</li>
                            <li><strong>Trabajo en equipo:</strong> Colaboracion efectiva entre todas las unidades.</li>
                            <li><strong>Responsabilidad:</strong> Cumplimiento oportuno de las funciones asignadas.</li>
                        </ul>
                    </div>
                </div>

                <!-- Tab de Normatividad -->
                <div class="tab-content" id="normatividad">
                    <div class="content-wrapper">
                        <h2>NORMATIVIDAD</h2>
                        <p>Marco normativo que rige las actividades de Gestion de la Calidad en la UNSM:</p>

                        <h3>Normativa Nacional</h3>
                        <ul class="funciones-list">
                            <li><strong>Ley N° 30220:</strong> Ley Universitaria - Establece los lineamientos para la calidad educativa universitaria.</li>
                            <li><strong>Ley N° 28740:</strong> Ley del SINEACE - Sistema Nacional de Evaluacion, Acreditacion y Certificacion de la Calidad Educativa.</li>
                            <li><strong>D.S. N° 016-2015-MINEDU:</strong> Politica de Aseguramiento de la Calidad de la Educacion Superior Universitaria.</li>
                            <li><strong>Resolucion N° 175-2018-SINEACE:</strong> Modelo de Acreditacion para Programas de Estudios de Educacion Superior Universitaria.</li>
                        </ul>

                        <h3>Normativa Institucional</h3>
                        <ul class="funciones-list">
                            <li><strong>Estatuto de la UNSM:</strong> Marco normativo general de la universidad.</li>
                            <li><strong>Reglamento de Organizacion y Funciones (ROF):</strong> Define las funciones de la OGC.</li>
                            <li><strong>Plan Estrategico Institucional:</strong> Objetivos y metas de calidad.</li>
                            <li><strong>Reglamento de Gestion de la Calidad:</strong> Normas especificas para los procesos de calidad.</li>
                            <li><strong>Manual de Procesos y Procedimientos:</strong> Guias para la implementacion de la calidad.</li>
                        </ul>
                    </div>
                </div>

                <!-- Tab de Logros -->
                <div class="tab-content" id="logros">
                    <div class="content-wrapper">
                        <h2>LOGROS</h2>
                        <p>Principales logros alcanzados por la Oficina de Gestion de la Calidad:</p>

                        <h3>Licenciamiento Institucional</h3>
                        <ul class="funciones-list">
                            <li><strong>Licenciamiento SUNEDU:</strong> La UNSM obtuvo el licenciamiento institucional, demostrando el cumplimiento de las condiciones basicas de calidad.</li>
                        </ul>

                        <h3>Acreditacion de Carreras Profesionales</h3>
                        <ul class="funciones-list">
                            <li>Carreras profesionales en proceso de autoevaluacion con fines de acreditacion.</li>
                            <li>Implementacion del modelo de acreditacion SINEACE en todas las facultades.</li>
                            <li>Capacitacion permanente a comites de calidad de las escuelas profesionales.</li>
                        </ul>

                        <h3>Mejora Continua</h3>
                        <ul class="funciones-list">
                            <li>Implementacion del Sistema de Gestion de Calidad institucional.</li>
                            <li>Desarrollo de indicadores de calidad para el seguimiento academico.</li>
                            <li>Elaboracion de planes de mejora en todas las unidades academicas.</li>
                            <li>Fortalecimiento de la cultura de calidad en la comunidad universitaria.</li>
                        </ul>
                    </div>
                </div>

                <!-- Tab de Nosotros -->
                <div class="tab-content" id="nosotros">
                    <div class="content-wrapper">
                        <h2>NOSOTROS</h2>
                        <p>Somos un equipo de profesionales comprometidos con la excelencia academica y la mejora continua de la Universidad Nacional de San Martin.</p>

                        <h3>Funciones Principales</h3>
                        <ul class="funciones-list">
                            <li>Proponer politicas y lineamientos para la gestion de la calidad institucional.</li>
                            <li>Coordinar los procesos de autoevaluacion y acreditacion de programas de estudios.</li>
                            <li>Brindar asistencia tecnica a las unidades academicas en materia de calidad.</li>
                            <li>Supervisar la implementacion de los planes de mejora institucionales.</li>
                            <li>Gestionar la informacion relacionada con los indicadores de calidad.</li>
                            <li>Promover la cultura de calidad en la comunidad universitaria.</li>
                            <li>Coordinar con entidades externas como SUNEDU y SINEACE.</li>
                            <li>Elaborar informes de seguimiento y evaluacion de la calidad educativa.</li>
                        </ul>

                        <h3>Estructura Organizacional</h3>
                        <p>La Oficina de Gestion de la Calidad cuenta con areas especializadas para atender las necesidades de la comunidad universitaria en materia de aseguramiento de la calidad educativa.</p>
                    </div>
                </div>

                <!-- Tab de Contacto -->
                <div class="tab-content" id="contacto">
                    <div class="content-wrapper">
                        <h2>CONTACTO</h2>
                        <p>Para consultas, sugerencias o informacion sobre procesos de calidad, puede comunicarse con nosotros:</p>

                        <h3>Informacion de Contacto</h3>
                        <ul class="funciones-list">
                            <li><strong>Correo Electronico:</strong> ogc@unsm.edu.pe</li>
                            <li><strong>Telefono:</strong> (042) 48 0159 - Anexo OGC</li>
                            <li><strong>Direccion:</strong> Local Central, Jr. Maynas N° 177, Tarapoto, Peru</li>
                        </ul>

                        <h3>Horario de Atencion</h3>
                        <p>Lunes a Viernes: 8:00 am - 1:00 pm y 3:00 pm - 6:00 pm</p>

                        <h3>Formulario de Contacto</h3>
                        <p>Puede enviar sus consultas a traves del correo electronico institucional o acercarse a nuestras oficinas en el horario establecido.</p>
                    </div>
                </div>

                <!-- Tab de Ubicacion -->
                <div class="tab-content" id="ubicacion">
                    <div class="content-wrapper">
                        <h2>UBICACION</h2>
                        <p>La Oficina de Gestion de la Calidad se encuentra ubicada en el Local Central de la Universidad Nacional de San Martin.</p>

                        <h3>Direccion</h3>
                        <ul class="funciones-list">
                            <li><strong>Direccion:</strong> Jr. Maynas N° 177</li>
                            <li><strong>Distrito:</strong> Tarapoto</li>
                            <li><strong>Provincia:</strong> San Martin</li>
                            <li><strong>Region:</strong> San Martin</li>
                            <li><strong>Pais:</strong> Peru</li>
                        </ul>

                        <h3>Referencias</h3>
                        <p>El Local Central de la UNSM se encuentra en el centro de la ciudad de Tarapoto, a pocas cuadras de la Plaza de Armas.</p>

                        <div class="mapa-container">
                            <iframe
                                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3985.9847012824!2d-76.37183492469726!3d-6.485025993502!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x91ba0fabf1fc47ad%3A0x87c7daf8d59c7a5e!2sUniversidad%20Nacional%20de%20San%20Martin!5e0!3m2!1ses!2spe!4v1704067200000!5m2!1ses!2spe"
                                width="100%"
                                height="350"
                                style="border:0; border-radius: 8px;"
                                allowfullscreen=""
                                loading="lazy"
                                referrerpolicy="no-referrer-when-downgrade">
                            </iframe>
                        </div>
                    </div>
                </div>

                <!-- Tab de Personal -->
                <div class="tab-content" id="personal">
                    <div class="content-wrapper">
                        <h2>PERSONAL</h2>
                        <p>La Oficina de Gestion de la Calidad cuenta con un equipo de profesionales especializados en gestion de la calidad educativa:</p>

                        <h3>Equipo de Trabajo</h3>
                        <ul class="funciones-list">
                            <li><strong>Jefe de Oficina:</strong> Responsable de la direccion y coordinacion general de la OGC.</li>
                            <li><strong>Especialista en Acreditacion:</strong> Encargado de coordinar los procesos de autoevaluacion y acreditacion.</li>
                            <li><strong>Especialista en Gestion de Calidad:</strong> Responsable de implementar el sistema de gestion de calidad.</li>
                            <li><strong>Analista de Calidad:</strong> Apoyo en la gestion de indicadores y elaboracion de informes.</li>
                            <li><strong>Asistente Administrativo:</strong> Apoyo en la gestion documentaria y administrativa.</li>
                        </ul>

                        <p>Nuestro equipo trabaja de manera coordinada para brindar el mejor servicio a la comunidad universitaria en materia de aseguramiento de la calidad.</p>
                    </div>
                </div>

                <!-- Tab de Eventos -->
                <div class="tab-content" id="eventos">
                    <div class="content-wrapper">
                        <h2>EVENTOS</h2>
                        <p>Actividades y eventos organizados por la Oficina de Gestion de la Calidad:</p>

                        <h3>Proximos Eventos</h3>
                        <ul class="funciones-list">
                            <li><strong>Taller de Autoevaluacion:</strong> Capacitacion dirigida a los comites de calidad de las escuelas profesionales.</li>
                            <li><strong>Seminario de Acreditacion:</strong> Informacion sobre el proceso de acreditacion SINEACE.</li>
                            <li><strong>Jornada de Mejora Continua:</strong> Intercambio de experiencias en implementacion de planes de mejora.</li>
                        </ul>

                        <h3>Eventos Realizados</h3>
                        <ul class="funciones-list">
                            <li><strong>Capacitacion en Estandares de Calidad:</strong> Formacion en el modelo de acreditacion de programas.</li>
                            <li><strong>Taller de Indicadores:</strong> Elaboracion y seguimiento de indicadores de calidad.</li>
                            <li><strong>Foro de Calidad Universitaria:</strong> Dialogo sobre buenas practicas en gestion de la calidad.</li>
                            <li><strong>Charlas de Sensibilizacion:</strong> Promocion de la cultura de calidad en la comunidad universitaria.</li>
                        </ul>

                        <p>Para participar en nuestros eventos, puede comunicarse con la oficina o estar atento a las publicaciones en los medios institucionales.</p>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- Footer -->
    <footer role="contentinfo">
        <div class="footer-content">
            <section class="footer-section">
                <div class="footer-logo-section">
                    <img src="../../../imagenes/escudo unsm.png" alt="Escudo oficial de la UNSM" class="footer-logo" width="60" height="auto">
                    <h3 class="footer-title">UNSM</h3>
                </div>
                <p class="footer-description">Centro Superior de Estudios autonomo y de caracter estatal, comprometido con la formacion de profesionales humanistas y competitivos, con responsabilidad social y comprometidos con el desarrollo local, regional y nacional.</p>
                <address>
                    <p>Jr. Maynas N° 177 - Morales</p>
                    <p>Tarapoto - San Martin - Peru</p>
                    <p>Central Telefonica: <span>(+51) (042) 48 0159</span></p>
                    <p>Email: <span>informes@unsm.edu.pe</span></p>
                </address>
            </section>

            <nav class="footer-section" aria-labelledby="footer-links-title">
                <h3 id="footer-links-title" class="footer-title">Enlaces Rapidos</h3>
                <ul class="footer-links">
                    <li><a href="../../../#admision">Admision</a></li>
                    <li><a href="../../../#facultades">Facultades</a></li>
                    <li><a href="../../../#posgrado">Posgrado</a></li>
                    <li><a href="../../../#investigacion">Investigacion</a></li>
                </ul>
            </nav>

            <nav class="footer-section" aria-labelledby="footer-services-title">
                <h3 id="footer-services-title" class="footer-title">Servicios</h3>
                <ul class="footer-links">
                    <li><a href="#biblioteca">Biblioteca Virtual</a></li>
                    <li><a href="#campus-virtual">Campus Virtual</a></li>
                    <li><a href="#repositorio">Repositorio Institucional</a></li>
                    <li><a href="#transparencia">Portal de Transparencia</a></li>
                    <li><a href="#libro-reclamaciones">Libro de Reclamaciones</a></li>
                    <li><a href="../../../contacto/indexContac.php">Enviar Mensaje</a></li>
                </ul>
            </nav>

            <section class="footer-section footer-facebook" aria-labelledby="footer-facebook-title">
                <h3 id="footer-facebook-title" class="footer-title">Facebook UNSM</h3>
                <!-- Plugin de Facebook -->
                <?php include 'plugin/meta.html'; ?>
            </section>
        </div>

        <div class="footer-bottom">
            <div class="footer-bottom-content">
                <p>&copy; 2025 Universidad Nacional de San Martin. Todos los derechos reservados.</p>
                <div class="footer-social-bottom">
                    <span class="footer-social-title">Siguenos</span>
                    <nav class="footer-social" aria-label="Redes sociales de la UNSM">
                        <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="Facebook UNSM">
                            <img src="../../../imagenes/redes/logo facebook.png" alt="Facebook" width="22" height="22">
                        </a>
                        <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" aria-label="Instagram UNSM">
                            <img src="../../../imagenes/redes/logo instagram.png" alt="Instagram" width="22" height="22">
                        </a>
                        <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" aria-label="YouTube UNSM">
                            <img src="../../../imagenes/redes/logo yt.png" alt="YouTube" width="22" height="22">
                        </a>
                        <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" aria-label="TikTok UNSM">
                            <img src="../../../imagenes/redes/logo tiktok.png" alt="TikTok" width="22" height="22">
                        </a>
                        <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="X (Twitter) UNSM">
                            <img src="../../../imagenes/redes/logo x.png" alt="X" width="22" height="22">
                        </a>
                    </nav>
                </div>
            </div>
        </div>
    </footer>

    <!-- Scripts -->
    <script src="../../../js/script.js"></script>
    <script src="script/scriptGesCali.js"></script>
    <div id="fb-root"></div>
    <script async defer crossorigin="anonymous" src="https://connect.facebook.net/es_LA/sdk.js#xfbml=1&version=v18.0"></script>
</body>
</html>
